#!/usr/bin/perl -w
$|++;
#	http://en.wikipedia.org/wiki/SubRip
#	SRT consists of four parts, all in text..

#	1. A number indicating which subtitle it is in the sequence.
#	2. The time that the subtitle should appear on the screen, and then disappear.
#	3. The subtitle itself.
#	4. A blank line indicating the start of a new subtitle.

#	The time format used is hours:minutes:seconds,milliseconds.

$numArgs = @ARGV;

if ($numArgs > 1) { 

	# check if first arg is a text file and if second arg exists

	die "$ARGV[0] is not a text file.\n" unless -f $ARGV[0] && -T $ARGV[0];

	# last chance to start over - if not "y" or "t" then die

	if (-e $ARGV[1]) {
	print "Do you want to over-write file? [yes]: ";
	chomp(my $decide = <STDIN>);
	$decide = 'y' if $decide eq '';
	die "Exiting, pick a different output filename.\n" unless $decide =~ /^[yt]/i;
	}
	chomp($infile = $ARGV[0]);
	$outfile = $ARGV[1];
#	map { print "$_\n" } @ARGV;
	preprocess ($infile, $outfile);

}  elsif ($numArgs > 0) { 
		chomp($infile = $ARGV[0]);
		$outfile = "srt_". $ARGV[0] . ".2ez";		# you can modify $outfile here
		print "the output filename will be $outfile\n";
#		map { print "$_\n" } @ARGV;
		preprocess ($infile, $outfile);

	# We'll look for some STDIN via IO redirection.
}  elsif ($numArgs < 1) { 
#		chomp($line = <STDIN>);
#		&preprocess;
		print "\n";
		print "srt2ez.pl minimally requires an input srt file entered like this -\n";
		print "perl srt2ez.pl infile.srt\n";
		print "\n";
		print "Optionally, srt2ez.pl accepts an output file name:\n";
		print "perl srt2ez.pl infile.srt outfile.txt\n";
		print "\n";
		print "srt2ez.pl will create an output file name if one is not entered.\n";
		print "\n";				
}

sub preprocess
{
if ($outfile){
	open (STDIN, "<$infile") or die "Can't open $infile: $!\n";
	open (OUT, ">$outfile") or die "Can't open $outfile: $!\n";
}	
	# Gnome Subtitles places UTF-8 byte order mark 
	# (hex EF BB BF) at the beginning of first line of every format output
	# Windows editors use CRLF for newlines.

while ($line = <STDIN>){
	$line =~ s/^\xef\xbb\xbf//;
	$line =~ s/\r\n/\n/;
	$line =~ s/\r/\n/;
	$line =~ s/,(\d\d\d)/.$1/g;

	if ($outfile){
		print OUT $line;
		}else{
			print $line;} 
}
close OUT;
close STDIN;

$ors_save = $/;
$/ = '';			# read in whole paragraph, not just one line

#	http://www.sthomas.net/roberts-perl-tutorial.htm/ch13/Modifying_a_File_with___I

if ($outfile){
@ARGV=$outfile;
}else{
@ARGV=">-";
}
$^I="";              # let the magic begin

while ($line = <>) {
		$line =~ s/(^\d+).*(^\d\d:\d\d:\d\d\.\d\d\d --> \d\d:\d\d:\d\d\.\d\d\d).*(^\[?\w+.*)/$1 $2 $3/sm;
      print $line;    # this goes to the temp filehandle, ARGVOUT, 
							 # not STDOUT as usual, so don't mess with it !
}
$/ = $ors_save;
&process;
}

sub seconds
{
# all variable passed to the perl subroutines are stored in special @_ variable
	return ($_[0] * 3600) + ($_[1] * 60) + $_[2];
}

sub process
{

if ($outfile){
@ARGV=$outfile;
}else{
@ARGV=">-";
}

while ( $line = <> ) {
		$line =~ s/^\d+\s/\t\t<span data-begin="/;
		$line =~ s/^\n//;										# comment this line for double space
		$line =~ s/ --> /" data-end="/;
		$line =~ s|(\d)\s(\[?\w+.*)|$1">$2</span>|;		#changed delimiter for slash in </span>
		$line =~ s/(\d\d):(\d\d):(\d\d)\.\d\d\d/seconds($1, $2, $3)/ge;
		print $line;    # this goes to the temp filehandle, ARGVOUT, 
							 # not STDOUT as usual, so don't mess with it !		
}
}